/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
struct Player : Game::Chr
{
   Motion attack;

   virtual void animate(); // extend skeleton animation
   virtual Bool update ();

   // io
   virtual void save(File &f);
   virtual Bool load(File &f);
};
/******************************************************************************/
void Player::animate()
{
   __super::animate(); // call default animations

   // now the skeleton is animated with default character animations (walking, running, crouching, ..)
   // so after the basic animations we can optionally replace them with custom ones, for example attacking:
   cskel.animate(attack,true); // animate skeleton with 'attack' animation motion, 'true' for replace animation mode
}
/******************************************************************************/
Bool Player::update()
{
   if(action)
   {
      if(Kb.b(KB_W) || Kb.b(KB_S) || Kb.b(KB_A) || Kb.b(KB_D) || Kb.b(KB_Q) || Kb.b(KB_E))actionBreak();
   }

   if(!action)
   {
      // turn & move
      input.anglei.x=Kb.b(KB_Q)-Kb.b(KB_E);
      input.anglei.y=Kb.b(KB_T)-Kb.b(KB_G);
      input.diri  .x=Kb.b(KB_D)-Kb.b(KB_A);
      input.diri  .z=Kb.b(KB_W)-Kb.b(KB_S);
      input.diri  .y=Kb.b(KB_SPACE)-Kb.b(KB_LSHIFT);

      // dodge, crouch, walk, jump
      input.dodge = Kb.bd(KB_D)-Kb.bd(KB_A);
      input.crouch= Kb.b (KB_LSHIFT);
      input.walk  = Kb.b (KB_LCTRL );
      input.jump  =(Kb.bp(KB_SPACE ) ? 3.5 : 0);

      // mouse turn
      Flt max=DegToRad(900)*Tm.d,
          dx =Ms.dir_ds.x*1.7,
          dy =Ms.dir_ds.y*1.7*Ms.inv();
      angle.x-=Mid(dx,-max,max);
      angle.y+=Mid(dy,-max,max);

      // ready stance change
      ready^=Kb.bp(KB_R);
   }

   // update animation
   {
      if(Kb.bp(KB_ENTER)) // on enter pressed
         attack.set(cskel,"anim/swing/r-l.anim"); // initialize "right-hand swing to left direction" attack animation

      attack.updateAuto(3,3,1); // update attack animation motion
   }

   return __super::update();
}
/******************************************************************************/
void Player::save(File &f)
{
   __super::save(f);

   attack.save(f);
}
Bool Player::load(File &f)
{
   if(__super::load(f))
   {
      return attack.load(f,cskel);
   }
   return false;
}
/******************************************************************************/
Game::ObjMemx<Game::Static> Statics;
Game::ObjMemx<Game::Item  > Items  ;
Game::ObjMemx<      Player> Players;
/******************************************************************************/
void InitPre()
{
   App.name="Character Animations";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).ambPower(0.3);
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sky    .set   ();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower();

   Game::World.init()
              .setType(Statics,OBJ_STATIC)
              .setItem(Items  ,OBJ_ITEM  )
              .setType(Players,OBJ_CHR   )
              .New    ("world/sample"    );

   Cam.setSpherical(Vec(16,0,16),-PI_4,-0.5,0,10).set();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   Game::World.update(Cam.at);

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press Enter to play a custom animation");
}
/******************************************************************************/
